(function () {
  const KEY = "quizcm_admin_theme";

  function applyTheme(theme) {
    document.documentElement.setAttribute("data-bs-theme", theme);
  }

  // Apply ASAP
  const saved = localStorage.getItem(KEY);
  if (saved === "light" || saved === "dark") {
    applyTheme(saved);
  }

  window.addEventListener("DOMContentLoaded", () => {
    const btn = document.getElementById("themeToggle");
    if (!btn) return;

    btn.addEventListener("click", () => {
      const cur = document.documentElement.getAttribute("data-bs-theme") || "dark";
      const next = cur === "dark" ? "light" : "dark";
      applyTheme(next);
      localStorage.setItem(KEY, next);
    });
  });
})();
