<?php
// $pageTitle optional
?>
<!doctype html>
<html lang="fr" data-bs-theme="dark">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle ?? "Admin Quiz CM") ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>

<nav class="navbar navbar-expand-lg bg-body-tertiary border-bottom sticky-top">
  <div class="container-fluid">
    <a class="navbar-brand fw-semibold" href="dashboard.php">Quiz CM</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav" aria-controls="nav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="nav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="dashboard.php">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="questions.php">Questions</a></li>
        <li class="nav-item"><a class="nav-link" href="classes.php">Classes</a></li>
        <li class="nav-item"><a class="nav-link" href="subjects.php">Filières</a></li>
        <li class="nav-item"><a class="nav-link" href="carousel.php">Diaporama</a></li>
        <li class="nav-item"><a class="nav-link" href="settings.php">Paramètres</a></li>
        <li class="nav-item"><a class="nav-link" href="users.php">Utilisateurs</a></li>
        <li class="nav-item"><a class="nav-link" href="reports.php">Signalements</a></li>
      </ul>

      <div class="d-flex align-items-center gap-2">
        <button id="themeToggle" class="btn btn-outline-secondary btn-sm" type="button" title="Mode sombre / clair">🌓</button>
        <?php if (isset($adminUser)): ?>
          <span class="text-body-secondary small d-none d-lg-inline"><?= htmlspecialchars($adminUser["email"]) ?></span>
        <?php endif; ?>
        <a class="btn btn-outline-danger btn-sm" href="logout.php">Déconnexion</a>
      </div>
    </div>
  </div>
</nav>

<main class="container py-4">