<?php
require_once __DIR__ . "/includes/admin_auth.php";
$adminUser = require_admin();

$pdo = db();

$msg = null;
$err = null;

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id = (int)($_POST["id"] ?? 0);
    $action = (string)($_POST["action"] ?? "");
    try {
        if ($id > 0 && $action === "resolve") {
            $stmt = $pdo->prepare("UPDATE reports SET is_resolved=1 WHERE id=?");
            $stmt->execute([$id]);
            $msg = "Signalement marqué comme résolu.";
        } elseif ($id > 0 && $action === "reopen") {
            $stmt = $pdo->prepare("UPDATE reports SET is_resolved=0 WHERE id=?");
            $stmt->execute([$id]);
            $msg = "Signalement rouvert.";
        } elseif ($id > 0 && $action === "delete") {
            $stmt = $pdo->prepare("DELETE FROM reports WHERE id=?");
            $stmt->execute([$id]);
            $msg = "Signalement supprimé.";
        }
    } catch (Throwable $e) {
        $err = "Action impossible.";
    }
}

$q = trim($_GET["q"] ?? "");
$status = trim($_GET["status"] ?? "open"); // open|resolved|all

$where = [];
$params = [];

if ($status === "open") {
    $where[] = "r.is_resolved=0";
} elseif ($status === "resolved") {
    $where[] = "r.is_resolved=1";
}

if ($q !== "") {
    $where[] = "(u.email LIKE ? OR u.phone LIKE ? OR u.display_name LIKE ? OR r.message LIKE ? OR r.question_text LIKE ?)";
    for ($i=0; $i<5; $i++) $params[] = "%$q%";
}

$whereSql = empty($where) ? "" : ("WHERE " . implode(" AND ", $where));

$stmt = $pdo->prepare(
    "SELECT r.id,r.created_at,r.is_resolved,r.question_text,r.message,
            u.display_name,u.email,u.phone,
            c.name AS class_name,
            s.name AS subject_name
     FROM reports r
     JOIN users u ON u.id=r.user_id
     JOIN classes c ON c.id=r.class_id
     JOIN subjects s ON s.id=r.subject_id
     $whereSql
     ORDER BY r.created_at DESC
     LIMIT 200"
);
$stmt->execute($params);
$rows = $stmt->fetchAll();

$pageTitle = "Signalements";
require __DIR__ . "/includes/header.php";
?>

<div class="card p-4 mb-3">
  <h5 class="mb-3">Signalements des utilisateurs</h5>

  <?php if ($msg): ?><div class="alert alert-success"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>

  <form method="get" class="row g-2 align-items-end">
    <div class="col-md-6">
      <label class="form-label">Recherche</label>
      <input class="form-control" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="email, téléphone, nom, mot-clé…">
    </div>
    <div class="col-md-3">
      <label class="form-label">Statut</label>
      <select class="form-select" name="status">
        <option value="open" <?= $status==='open'?'selected':'' ?>>Ouverts</option>
        <option value="resolved" <?= $status==='resolved'?'selected':'' ?>>Résolus</option>
        <option value="all" <?= $status==='all'?'selected':'' ?>>Tous</option>
      </select>
    </div>
    <div class="col-md-3">
      <button class="btn btn-primary w-100">Filtrer</button>
    </div>
  </form>
</div>

<div class="card p-4">
  <div class="d-flex align-items-center justify-content-between mb-2">
    <h6 class="mb-0"><?= count($rows) ?> signalement(s)</h6>
    <div class="text-white-50 small">Derniers 200 résultats</div>
  </div>

  <?php if (empty($rows)): ?>
    <div class="text-white-50">Aucun signalement pour le moment.</div>
  <?php else: ?>
    <div class="table-responsive">
      <table class="table table-hover align-middle">
        <thead>
          <tr>
            <th>Date</th>
            <th>Utilisateur</th>
            <th>Classe</th>
            <th>Filière</th>
            <th>Question</th>
            <th>Message</th>
            <th class="text-end">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td class="small text-white-50"><?= htmlspecialchars($r['created_at']) ?></td>
              <td>
                <div class="fw-semibold"><?= htmlspecialchars($r['display_name']) ?></div>
                <div class="small text-white-50"><?= htmlspecialchars($r['email']) ?> • <?= htmlspecialchars($r['phone'] ?? '—') ?></div>
              </td>
              <td><span class="badge badge-soft"><?= htmlspecialchars($r['class_name']) ?></span></td>
              <td><?= htmlspecialchars($r['subject_name']) ?></td>
              <td style="max-width:320px">
                <div class="small text-truncate" title="<?= htmlspecialchars($r['question_text']) ?>"><?= htmlspecialchars($r['question_text']) ?></div>
              </td>
              <td style="max-width:360px">
                <div class="small"><?= nl2br(htmlspecialchars($r['message'])) ?></div>
              </td>
              <td class="text-end">
                <div class="d-inline-flex gap-2">
                  <form method="post">
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <?php if ((int)$r['is_resolved']===0): ?>
                      <button class="btn btn-sm btn-outline-success" name="action" value="resolve">Résoudre</button>
                    <?php else: ?>
                      <button class="btn btn-sm btn-outline-warning" name="action" value="reopen">Rouvrir</button>
                    <?php endif; ?>
                  </form>
                  <form method="post" onsubmit="return confirm('Supprimer ce signalement ?')">
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <button class="btn btn-sm btn-outline-danger" name="action" value="delete">Supprimer</button>
                  </form>
                </div>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<?php require __DIR__ . "/includes/footer.php"; ?>
