<?php
require_once __DIR__ . "/includes/admin_auth.php";
require_once __DIR__ . "/includes/meta.php";

$adminUser = require_admin();
$pdo = db();

$msg = null;
$err = null;

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $quizTime = (int)($_POST["quiz_time_seconds"] ?? 20);
  $defaultPoints = (int)($_POST["default_points"] ?? 3);
  $carouselInterval = (int)($_POST["carousel_interval_seconds"] ?? 5);

  // --- Ads (AdMob) ---
  $adsEnabled = isset($_POST['ads_enabled']) ? '1' : '0';
  $bannerEnabled = isset($_POST['banner_enabled']) ? '1' : '0';
  $interstitialEnabled = isset($_POST['interstitial_enabled']) ? '1' : '0';
  $bannerUnitId = trim((string)($_POST['admob_banner_unit_id'] ?? ''));
  $interstitialUnitId = trim((string)($_POST['admob_interstitial_unit_id'] ?? ''));
  $interstitialEvery = (int)($_POST['interstitial_every'] ?? 1);
  $interstitialCooldown = (int)($_POST['interstitial_cooldown_seconds'] ?? 30);
  $childDirected = isset($_POST['ads_child_directed']) ? '1' : '0';
  $nonPersonalized = isset($_POST['ads_non_personalized']) ? '1' : '0';
  $consentEnabled = isset($_POST['ads_consent_enabled']) ? '1' : '0';

  $quizTime = max(5, min(600, $quizTime));
  $defaultPoints = max(0, min(9999, $defaultPoints));
  $carouselInterval = max(2, min(60, $carouselInterval));

  $interstitialEvery = max(1, min(50, $interstitialEvery));
  $interstitialCooldown = max(0, min(3600, $interstitialCooldown));

  try {
    upsert_setting($pdo, "quiz_time_seconds", (string)$quizTime);
    upsert_setting($pdo, "default_points", (string)$defaultPoints);
    upsert_setting($pdo, "carousel_interval_seconds", (string)$carouselInterval);

    // Ads (AdMob)
    upsert_setting($pdo, "ads_enabled", $adsEnabled);
    upsert_setting($pdo, "banner_enabled", $bannerEnabled);
    upsert_setting($pdo, "interstitial_enabled", $interstitialEnabled);
    upsert_setting($pdo, "admob_banner_unit_id", $bannerUnitId);
    upsert_setting($pdo, "admob_interstitial_unit_id", $interstitialUnitId);
    upsert_setting($pdo, "interstitial_every", (string)$interstitialEvery);
    upsert_setting($pdo, "interstitial_cooldown_seconds", (string)$interstitialCooldown);
    upsert_setting($pdo, "ads_child_directed", $childDirected);
    upsert_setting($pdo, "ads_non_personalized", $nonPersonalized);
    upsert_setting($pdo, "ads_consent_enabled", $consentEnabled);

    $msg = "Paramètres enregistrés.";
  } catch (Throwable $e) {
    $err = "Impossible d'enregistrer les paramètres.";
  }
}

$quizTimeCur = (int)get_setting($pdo, "quiz_time_seconds", "20");
$defaultPointsCur = (int)get_setting($pdo, "default_points", "3");
$carouselIntervalCur = (int)get_setting($pdo, "carousel_interval_seconds", "5");

// Ads (AdMob)
$adsEnabledCur = (int)get_setting($pdo, "ads_enabled", "0");
$bannerEnabledCur = (int)get_setting($pdo, "banner_enabled", "0");
$interstitialEnabledCur = (int)get_setting($pdo, "interstitial_enabled", "0");
$bannerUnitIdCur = (string)get_setting($pdo, "admob_banner_unit_id", "");
$interstitialUnitIdCur = (string)get_setting($pdo, "admob_interstitial_unit_id", "");
$interstitialEveryCur = (int)get_setting($pdo, "interstitial_every", "1");
$interstitialCooldownCur = (int)get_setting($pdo, "interstitial_cooldown_seconds", "30");
$childDirectedCur = (int)get_setting($pdo, "ads_child_directed", "1");
$nonPersonalizedCur = (int)get_setting($pdo, "ads_non_personalized", "1");
$consentEnabledCur = (int)get_setting($pdo, "ads_consent_enabled", "1");

$pageTitle = "Paramètres";
require __DIR__ . "/includes/header.php";
?>

<div class="card p-4">
  <h5 class="mb-3">Paramètres de l'application</h5>

  <?php if ($msg): ?><div class="alert alert-success"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>

  <form method="post" class="row g-3">
    <div class="col-md-6">
      <label class="form-label">Temps (compte à rebours) par question (secondes)</label>
      <input class="form-control" type="number" min="5" max="600" name="quiz_time_seconds" value="<?= (int)$quizTimeCur ?>" required>
      <div class="form-text">Min 5s, max 10 minutes.</div>
    </div>
    <div class="col-md-6">
      <label class="form-label">Points de départ lors d'une inscription</label>
      <input class="form-control" type="number" min="0" max="9999" name="default_points" value="<?= (int)$defaultPointsCur ?>" required>
      <div class="form-text">Vous pouvez par exemple mettre 5 points.</div>
    </div>
    <div class="col-md-6">
      <label class="form-label">Temps du diaporama (secondes par image)</label>
      <input class="form-control" type="number" min="2" max="60" name="carousel_interval_seconds" value="<?= (int)$carouselIntervalCur ?>" required>
      <div class="form-text">Min 2s, max 60s.</div>
    </div>

    <div class="col-12">
      <h6 class="mt-3 mb-2">Publicités (AdMob)</h6>
      <div class="alert alert-warning py-2 mb-2">
        <strong>Important :</strong> utilisez les IDs <em>test</em> pendant le développement. Remplacez par vos vrais IDs avant publication.
      </div>
    </div>

    <div class="col-md-4">
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="ads_enabled" id="ads_enabled" <?= $adsEnabledCur ? 'checked' : '' ?>>
        <label class="form-check-label" for="ads_enabled">Activer les pubs</label>
      </div>
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="banner_enabled" id="banner_enabled" <?= $bannerEnabledCur ? 'checked' : '' ?>>
        <label class="form-check-label" for="banner_enabled">Bannière en bas (quiz)</label>
      </div>
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="interstitial_enabled" id="interstitial_enabled" <?= $interstitialEnabledCur ? 'checked' : '' ?>>
        <label class="form-check-label" for="interstitial_enabled">Interstitiel à l'entrée du quiz</label>
      </div>
    </div>

    <div class="col-md-8">
      <label class="form-label">Ad Unit ID Bannière (Android)</label>
      <input class="form-control" type="text" name="admob_banner_unit_id" value="<?= htmlspecialchars($bannerUnitIdCur) ?>" placeholder="ca-app-pub-XXXXXXXXXXXXXXXX/BBBBBBBBBB">
      <div class="form-text">Exemple (test) : <code>ca-app-pub-3940256099942544/6300978111</code></div>

      <label class="form-label mt-3">Ad Unit ID Interstitiel (Android)</label>
      <input class="form-control" type="text" name="admob_interstitial_unit_id" value="<?= htmlspecialchars($interstitialUnitIdCur) ?>" placeholder="ca-app-pub-XXXXXXXXXXXXXXXX/IIIIIIIIII">
      <div class="form-text">Exemple (test) : <code>ca-app-pub-3940256099942544/1033173712</code></div>
    </div>

    <div class="col-md-6">
      <label class="form-label">Fréquence interstitiels (1 = à chaque clic sur une filière)</label>
      <input class="form-control" type="number" min="1" max="50" name="interstitial_every" value="<?= (int)$interstitialEveryCur ?>" required>
      <div class="form-text">Ex: 1 = chaque clic, 2 = un clic sur 2, 3 = un clic sur 3, etc.</div>
    </div>

    <div class="col-md-6">
      <label class="form-label">Cooldown interstitiels (secondes)</label>
      <input class="form-control" type="number" min="0" max="3600" name="interstitial_cooldown_seconds" value="<?= (int)$interstitialCooldownCur ?>" required>
      <div class="form-text">Évite d'enchaîner trop d'interstitiels (ex: 30s).</div>
    </div>

    <div class="col-md-6">
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="ads_child_directed" id="ads_child_directed" <?= $childDirectedCur ? 'checked' : '' ?>>
        <label class="form-check-label" for="ads_child_directed">Audience enfant (COPPA / Designed for Families)</label>
      </div>
      <div class="form-text">Si l'app cible des enfants, gardez ceci activé.</div>
    </div>

    <div class="col-md-6">
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="ads_non_personalized" id="ads_non_personalized" <?= $nonPersonalizedCur ? 'checked' : '' ?>>
        <label class="form-check-label" for="ads_non_personalized">Forcer des pubs non personnalisées (NPA)</label>
      </div>
      <div class="form-text">Recommandé si vous visez des enfants ou si vous n'avez pas de consentement.</div>
    </div>

    <div class="col-md-6">
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="ads_consent_enabled" id="ads_consent_enabled" <?= $consentEnabledCur ? 'checked' : '' ?>>
        <label class="form-check-label" for="ads_consent_enabled">Afficher le consentement (Google UMP)</label>
      </div>
      <div class="form-text">
        Si activé, l'app demande le consentement <strong>une seule fois</strong> (sauf si Google exige de le redemander après une mise à jour).
        Si désactivé, l'app <strong>force</strong> des pubs non personnalisées.
      </div>
    </div>

    <div class="col-12">
      <button class="btn btn-primary">Enregistrer</button>
    </div>
  </form>

  <hr class="my-4">
  <div class="small-muted">
    <div><strong>Note :</strong> L'application Android lit ces paramètres automatiquement depuis l'API (<code>/api/settings</code>).</div>
  </div>
</div>

<?php require __DIR__ . "/includes/footer.php"; ?>
