<?php
session_start();
require_once __DIR__ . "/../api/db.php";

$pdo = db();
$hasAdmin = (bool)$pdo->query("SELECT id FROM users WHERE role='admin' LIMIT 1")->fetch();

$message = null;

if ($hasAdmin) {
    $message = "Un administrateur existe déjà. Connectez-vous.";
} else if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = strtolower(trim($_POST["email"] ?? ""));
    $name = trim($_POST["name"] ?? "Admin");
    $pass = (string)($_POST["password"] ?? "");

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "Email invalide.";
    } else if (strlen($pass) < 8) {
        $message = "Mot de passe trop court (min 8).";
    } else {
        $hash = password_hash($pass, PASSWORD_BCRYPT);
        // Admin: class_id obligatoire (on met la première classe disponible)
        $classId = (int)$pdo->query("SELECT id FROM classes ORDER BY id ASC LIMIT 1")->fetchColumn();
        if ($classId <= 0) { $classId = 1; }
        $stmt = $pdo->prepare("INSERT INTO users (email,password_hash,display_name,class_id,points,role,created_at,updated_at)
                               VALUES (?,?,?,?,?,'admin',NOW(),NOW())");
        $stmt->execute([$email, $hash, $name, $classId, 0]);
        $message = "Admin créé. Vous pouvez vous connecter.";
        $hasAdmin = true;
    }
}

?>
<!doctype html>
<html lang="fr" data-bs-theme="dark">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Setup Admin - Quiz CM</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <script>
    // Appliquer le thème dès que possible (avant le rendu)
    (function(){
      try{
        var t = localStorage.getItem('quizcm_admin_theme');
        if(t==='light' || t==='dark') document.documentElement.setAttribute('data-bs-theme', t);
      }catch(e){}
    })();
  </script>
</head>
<body>
<div class="container py-5" style="max-width: 760px;">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <h1 class="mb-1">Création du premier administrateur</h1>
      <p class="small-muted mb-0">Après création, supprimez ce fichier <code>/admin/setup.php</code> pour la sécurité.</p>
    </div>
    <button id="themeToggle" class="btn btn-outline-secondary btn-sm" type="button" title="Mode sombre / clair">🌓</button>
  </div>

  <?php if ($message): ?>
    <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
  <?php endif; ?>

  <?php if (!$hasAdmin): ?>
  <form method="post" class="card p-4">
    <div class="mb-3">
      <label class="form-label">Nom affiché</label>
      <input class="form-control" name="name" placeholder="Admin">
    </div>
    <div class="mb-3">
      <label class="form-label">Email</label>
      <input class="form-control" type="email" name="email" required placeholder="admin@votredomaine.com">
    </div>
    <div class="mb-3">
      <label class="form-label">Mot de passe (min 8)</label>
      <input class="form-control" type="password" name="password" required>
    </div>
    <button class="btn btn-primary">Créer l'admin</button>
  </form>
  <?php else: ?>
    <a class="btn btn-primary" href="login.php">Aller à la page de connexion</a>
  <?php endif; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/admin.js"></script>
</body>
</html>
