<?php
require_once __DIR__ . "/includes/admin_auth.php";
$adminUser = require_admin();

$pdo = db();

$id = (int)($_GET["id"] ?? 0);
if ($id <= 0) {
    header("Location: users.php");
    exit;
}

$stmt = $pdo->prepare(
  "SELECT u.id,u.display_name,u.email,u.phone,c.name AS class_name,u.points
   FROM users u JOIN classes c ON c.id=u.class_id
   WHERE u.id = ? AND u.role='student' LIMIT 1"
);
$stmt->execute([$id]);
$u = $stmt->fetch();
if (!$u) {
    header("Location: users.php");
    exit;
}

$msg = null;
$err = null;

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $newPass = (string)($_POST["password"] ?? "");
    if (strlen($newPass) < 6) {
        $err = "Mot de passe trop court (min 6).";
    } else {
        $hash = password_hash($newPass, PASSWORD_BCRYPT);
        $stmt = $pdo->prepare("UPDATE users SET password_hash = ?, updated_at = NOW() WHERE id = ?");
        $stmt->execute([$hash, $id]);
        $msg = "Mot de passe mis à jour.";
    }
}

$pageTitle = "Modifier mot de passe";
require __DIR__ . "/includes/header.php";
?>

<div class="card p-4">
  <h5 class="mb-2">Modifier le mot de passe</h5>
  <div class="text-white-50 mb-3">
    <?= htmlspecialchars($u["display_name"]) ?> • <?= htmlspecialchars($u["email"]) ?> • <?= htmlspecialchars($u["phone"] ?? "—") ?> • <?= htmlspecialchars($u["class_name"]) ?> • Points: <?= (int)$u["points"] ?>
  </div>

  <?php if ($msg): ?><div class="alert alert-success"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>

  <form method="post" class="row g-3">
    <div class="col-12">
      <label class="form-label">Nouveau mot de passe</label>
      <input class="form-control" type="password" name="password" required>
      <div class="small-muted mt-1">Conseil: donnez un mot de passe temporaire et dites à l'utilisateur de le changer plus tard.</div>
    </div>
    <div class="col-12 d-flex gap-2">
      <button class="btn btn-primary">Enregistrer</button>
      <a class="btn btn-outline-secondary" href="users.php">Retour</a>
    </div>
  </form>
</div>

<?php require __DIR__ . "/includes/footer.php"; ?>
