<?php
require_once __DIR__ . "/includes/admin_auth.php";
require_once __DIR__ . "/includes/meta.php";
$adminUser = require_admin();

$pdo = db();
$classOptions = get_classes($pdo, true);

$backQ = trim($_POST["back_q"] ?? "");
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $action = $_POST["action"] ?? "";
    $id = (int)($_POST["id"] ?? 0);
    if ($id > 0) {
        if ($action === "toggle_block") {
            $stmt = $pdo->prepare("UPDATE users SET is_blocked = IF(is_blocked=1,0,1), updated_at=NOW() WHERE id=? AND role='student'");
            $stmt->execute([$id]);
        } elseif ($action === "change_class") {
            $classId = (int)($_POST["class_id"] ?? 0);
            if ($classId > 0) {
                // Only active classes
                $stmt = $pdo->prepare("SELECT id FROM classes WHERE id=? AND is_active=1 LIMIT 1");
                $stmt->execute([$classId]);
                if ($stmt->fetch()) {
                    $stmt = $pdo->prepare("UPDATE users SET class_id=?, updated_at=NOW() WHERE id=? AND role='student'");
                    $stmt->execute([$classId, $id]);
                }
            }
        } elseif ($action === "adjust_points") {
            $delta = (int)($_POST["delta"] ?? 0);
            // Avoid crazy values
            if ($delta > 5000) $delta = 5000;
            if ($delta < -5000) $delta = -5000;
            $stmt = $pdo->prepare("UPDATE users SET points = GREATEST(0, points + ?), updated_at=NOW() WHERE id=? AND role='student'");
            $stmt->execute([$delta, $id]);
        }
    }
    $redir = "users.php";
    if ($backQ !== "") {
        $redir .= "?q=" . urlencode($backQ);
    }
    header("Location: $redir");
    exit;
}

$query = trim($_GET["q"] ?? "");
$users = [];
if ($query !== "") {
    $stmt = $pdo->prepare(
        "SELECT u.id,u.display_name,u.email,u.phone,u.class_id,c.name AS class_name,u.points,u.is_blocked,u.created_at
         FROM users u JOIN classes c ON c.id=u.class_id
         WHERE u.role='student' AND (u.email LIKE ? OR u.phone LIKE ?)
         ORDER BY u.points DESC, u.id ASC LIMIT 50"
    );
    $stmt->execute(["%$query%","%$query%"]);
    $users = $stmt->fetchAll();
}

$top = $pdo->query(
    "SELECT u.id,u.display_name,u.email,u.phone,u.class_id,c.name AS class_name,u.points,u.is_blocked,u.created_at
     FROM users u JOIN classes c ON c.id=u.class_id
     WHERE u.role='student'
     ORDER BY u.points DESC, u.id ASC LIMIT 50"
)->fetchAll();

$pageTitle = "Utilisateurs";
require __DIR__ . "/includes/header.php";
?>

<div class="card p-4 mb-3">
  <h5 class="mb-3">Rechercher un utilisateur (par email ou téléphone)</h5>
  <form method="get" class="d-flex gap-2">
    <input class="form-control" name="q" placeholder="ex: eleve@gmail.com ou +2376..." value="<?= htmlspecialchars($query) ?>">
    <button class="btn btn-primary">Chercher</button>
  </form>

  <?php if ($query !== ""): ?>
    <div class="mt-3">
      <h6>Résultats</h6>
      <?php if (empty($users)): ?>
        <div class="text-white-50">Aucun utilisateur trouvé.</div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-hover align-middle">
            <thead><tr><th>Nom</th><th>Email</th><th>Téléphone</th><th>Classe</th><th>Statut</th><th class="text-end">Points</th><th class="text-end">Actions</th></tr></thead>
            <tbody>
              <?php foreach ($users as $u): ?>
                <tr>
                  <td><?= htmlspecialchars($u["display_name"]) ?></td>
                  <td><?= htmlspecialchars($u["email"]) ?></td>
                  <td><?= htmlspecialchars($u["phone"] ?? "—") ?></td>
                  <td><span class="badge badge-soft"><?= htmlspecialchars($u["class_name"]) ?></span></td>
                  <td>
                    <?php if ((int)$u['is_blocked'] === 1): ?>
                      <span class="badge text-bg-danger">Bloqué</span>
                    <?php else: ?>
                      <span class="badge text-bg-success">Actif</span>
                    <?php endif; ?>
                  </td>
                  <td class="text-end fw-semibold"><?= (int)$u["points"] ?></td>
                  <td class="text-end">
                    <div class="d-inline-flex flex-wrap gap-2 justify-content-end">
                      <form method="post" class="d-inline-flex gap-1 align-items-center">
                        <input type="hidden" name="action" value="adjust_points">
                        <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                        <input type="hidden" name="back_q" value="<?= htmlspecialchars($query) ?>">
                        <input class="form-control form-control-sm" type="number" name="delta" value="1" style="width: 86px" title="+/- points">
                        <button class="btn btn-sm btn-outline-primary" type="submit">Appliquer</button>
                      </form>

                      <form method="post" class="d-inline">
                        <input type="hidden" name="action" value="toggle_block">
                        <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                        <input type="hidden" name="back_q" value="<?= htmlspecialchars($query) ?>">
                        <?php if ((int)$u['is_blocked'] === 1): ?>
                          <button class="btn btn-sm btn-success" type="submit">Débloquer</button>
                        <?php else: ?>
                          <button class="btn btn-sm btn-warning" type="submit">Bloquer</button>
                        <?php endif; ?>
                      </form>

                                            <form method="post" class="d-inline-flex gap-1 align-items-center">
                        <input type="hidden" name="action" value="change_class">
                        <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                        <input type="hidden" name="back_q" value="<?= htmlspecialchars($query) ?>">
                        <select class="form-select form-select-sm" name="class_id" style="width: 120px" title="Changer la classe">
                          <?php foreach ($classOptions as $copt): ?>
                            <option value="<?= (int)$copt['id'] ?>" <?php if ((int)$copt['id'] === (int)$u['class_id']) echo "selected"; ?>><?= htmlspecialchars($copt['name']) ?></option>
                          <?php endforeach; ?>
                        </select>
                        <button class="btn btn-sm btn-outline-primary" type="submit">Changer</button>
                      </form>

                      <a class="btn btn-sm btn-outline-secondary" href="user_reset_password.php?id=<?= (int)$u['id'] ?>">Mot de passe</a>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>

<div class="card p-4">
  <h5 class="mb-3">Top 50 (les plus forts)</h5>
  <div class="table-responsive">
    <table class="table table-hover align-middle">
      <thead><tr><th>#</th><th>Nom</th><th>Email</th><th>Téléphone</th><th>Classe</th><th>Statut</th><th class="text-end">Points</th><th class="text-end">Actions</th></tr></thead>
      <tbody>
        <?php foreach ($top as $i => $u): ?>
          <tr>
            <td><?= $i+1 ?></td>
            <td><?= htmlspecialchars($u["display_name"]) ?></td>
            <td><?= htmlspecialchars($u["email"]) ?></td>
                  <td><?= htmlspecialchars($u["phone"] ?? "—") ?></td>
            <td><span class="badge badge-soft"><?= htmlspecialchars($u["class_name"]) ?></span></td>
            <td>
              <?php if ((int)$u['is_blocked'] === 1): ?>
                <span class="badge text-bg-danger">Bloqué</span>
              <?php else: ?>
                <span class="badge text-bg-success">Actif</span>
              <?php endif; ?>
            </td>
            <td class="text-end fw-semibold"><?= (int)$u["points"] ?></td>
            <td class="text-end">
              <div class="d-inline-flex flex-wrap gap-2 justify-content-end">
                <form method="post" class="d-inline-flex gap-1 align-items-center">
                  <input type="hidden" name="action" value="adjust_points">
                  <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                  <input type="hidden" name="back_q" value="">
                  <input class="form-control form-control-sm" type="number" name="delta" value="1" style="width: 86px" title="+/- points">
                  <button class="btn btn-sm btn-outline-primary" type="submit">Appliquer</button>
                </form>

                <form method="post" class="d-inline">
                  <input type="hidden" name="action" value="toggle_block">
                  <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                  <input type="hidden" name="back_q" value="">
                  <?php if ((int)$u['is_blocked'] === 1): ?>
                    <button class="btn btn-sm btn-success" type="submit">Débloquer</button>
                  <?php else: ?>
                    <button class="btn btn-sm btn-warning" type="submit">Bloquer</button>
                  <?php endif; ?>
                </form>

                                      <form method="post" class="d-inline-flex gap-1 align-items-center">
                        <input type="hidden" name="action" value="change_class">
                        <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                        <input type="hidden" name="back_q" value="<?= htmlspecialchars($query) ?>">
                        <select class="form-select form-select-sm" name="class_id" style="width: 120px" title="Changer la classe">
                          <?php foreach ($classOptions as $copt): ?>
                            <option value="<?= (int)$copt['id'] ?>" <?php if ((int)$copt['id'] === (int)$u['class_id']) echo "selected"; ?>><?= htmlspecialchars($copt['name']) ?></option>
                          <?php endforeach; ?>
                        </select>
                        <button class="btn btn-sm btn-outline-primary" type="submit">Changer</button>
                      </form>

                      <a class="btn btn-sm btn-outline-secondary" href="user_reset_password.php?id=<?= (int)$u["id"] ?>">Mot de passe</a>
              </div>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require __DIR__ . "/includes/footer.php"; ?>
