<?php

function cors(): void {
    header("Access-Control-Allow-Origin: *"); // Pour une app mobile, c'est OK; vous pouvez restreindre plus tard.
    header("Access-Control-Allow-Headers: Content-Type, Authorization");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
        http_response_code(204);
        exit;
    }
}

function json_response($data, int $code = 200): void {
    http_response_code($code);
    header("Content-Type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

function get_json_body(): array {
    $raw = file_get_contents("php://input");
    if (!$raw) return [];
    $decoded = json_decode($raw, true);
    return is_array($decoded) ? $decoded : [];
}

function require_fields(array $data, array $fields): void {
    foreach ($fields as $f) {
        if (!isset($data[$f]) || trim((string)$data[$f]) === "") {
            json_response(["error" => "Champ manquant: $f"], 400);
        }
    }
}

function random_token(int $bytes = 32): string {
    return bin2hex(random_bytes($bytes));
}

function normalize_subject(string $s): string {
    $s = trim($s);
    // Normaliser quelques variations
    $map = [
        "Histoires" => "Histoire",
        "Histoire" => "Histoire",
        "Français" => "Français",
        "Francais" => "Français",
        "Géographie" => "Géographie",
        "Geographie" => "Géographie",
        "SVT" => "SVT",
        "Anglais" => "Anglais",
        "Physique" => "Physique",
    ];
    return $map[$s] ?? $s;
}

function get_setting(PDO $pdo, string $key, string $default = ""): string {
    try {
        $stmt = $pdo->prepare("SELECT v FROM settings WHERE k = ? LIMIT 1");
        $stmt->execute([$key]);
        $row = $stmt->fetch();
        if ($row && isset($row["v"])) return (string)$row["v"]; 
    } catch (Throwable $_) {
        // ignore
    }
    return $default;
}

function mask_email(string $email): string {
    $email = trim($email);
    if ($email === "" || strpos($email, "@") === false) return $email;

    [$local, $domain] = explode("@", $email, 2);
    if (strlen($local) <= 2) {
        $first = $local !== "" ? $local[0] : "";
        return $first . "•••@" . $domain;
    }

    $start = substr($local, 0, 2);
    $end = strlen($local) >= 4 ? substr($local, -1) : "";
    return $start . "•••" . $end . "@" . $domain;
}
