-- Migration: ajouter is_active aux classes et filières (subjects)
-- Exécutez ce fichier UNE SEULE FOIS via phpMyAdmin > Import (format SQL)

SET @has_col := (
  SELECT COUNT(*) FROM information_schema.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE()
    AND TABLE_NAME = 'classes'
    AND COLUMN_NAME = 'is_active'
);
SET @sql := IF(@has_col = 0,
  'ALTER TABLE classes ADD COLUMN is_active TINYINT(1) NOT NULL DEFAULT 1 AFTER name;',
  'SELECT 1;'
);
PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;

SET @has_col2 := (
  SELECT COUNT(*) FROM information_schema.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE()
    AND TABLE_NAME = 'subjects'
    AND COLUMN_NAME = 'is_active'
);
SET @sql2 := IF(@has_col2 = 0,
  'ALTER TABLE subjects ADD COLUMN is_active TINYINT(1) NOT NULL DEFAULT 1 AFTER sort_order;',
  'SELECT 1;'
);
PREPARE stmt2 FROM @sql2; EXECUTE stmt2; DEALLOCATE PREPARE stmt2;

-- Optionnel: s'assurer que tout l'existant est actif par défaut
UPDATE classes SET is_active = 1 WHERE is_active IS NULL;
UPDATE subjects SET is_active = 1 WHERE is_active IS NULL;
